import React, { useEffect, useState } from "react";
import './App.css'

function App() {
  const [products, setProducts] = useState([]);
  const [page, setPage] = useState(0);
  const pageSize = 10;

  // Check if the app is running on localhost  
  let leapHost;
  if (window.location.hostname === 'localhost') {
     // For local development, use the full anonymous path - remove when going to production
     leapHost = 'https://dx.sbx0357.play.hclsofy.com/apps/anon/';
  } else {
    // For production, use the secure path
    leapHost = '/apps/secure/';
  }
  
  // Set Leap application and form ID
  const leapAppId = '49104c7d-48b1-45a4-85cb-ba684880ca6b';
  const leapFormId = 'F_Product';      

  // Get the list of products using the Leap DATA REST API
  const getProducts = () => {
    fetch(
      `${leapHost}org/data/${leapAppId}/${leapFormId}/?format=application/json`
    )
      .then((res) => res.json())
      .then((data) => {
        setProducts(data.items || []);
      })
      .catch(() => { });
  };

  // At load show the list of products
  useEffect(() => {
    getProducts();
  }, []);
  
  // Listen for the updated-product-event to refresh the product list
  useEffect(() => {
    const handleUpdatedProductEvent = () => {
      getProducts();
    };

    window.addEventListener('updated-product-event', handleUpdatedProductEvent);

    return () => {
      window.removeEventListener('updated-product-event', handleUpdatedProductEvent);
    };
  }, []);

  // Handle the edit button click to dispatch the selected-product-event
  const handleEdit = (item) => {
    window.dispatchEvent(new CustomEvent('selected-product-event', { detail: { message: item.uid } }));
  };

  // Pagination logic
  const start = page * pageSize;
  const end = start + pageSize;
  const pageProducts = products.slice(start, end);

  return (
    <div className="container p-4">
      <div className="card border">
        <div className="card-header bg-primary text-white">
          <h4 className="fw-semibold">Product List</h4>
        </div>
        <div className="card-body border-0 p-0">
          <table className="table table-sm table-bordered align-middle mb-0">
            <thead className="table-light">
              <tr>
                <th className="py-1 px-2">Name</th>
                <th className="py-1 px-2">Price ($)</th>
                <th className="py-1 px-2 text-center" style={{ width: 40 }}>Edit</th>
              </tr>
             </thead>
             <tbody>
              {pageProducts.map((item) => (
                <tr key={item.uid}>
                  <td className="py-1 px-2">{item.F_Name1}</td>
                  <td className="py-1 px-2">
                    {item.F_Price1 !== undefined && item.F_Price1 !== null
                      ? Number(item.F_Price1).toFixed(2)
                      : ""}
                  </td>
                  <td className="py-1 px-2 text-center">
                  <button className="btn btn-link btn-sm p-0" title="Edit" onClick={() => handleEdit(item)}>
                    <i className="fas fa-edit text-primary"></i>
                  </button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
      <div className="card-footer border-0">
        <div className="d-flex align-items-center justify-content-end mt-2">
          <button className="btn btn-outline-primary btn-sm me-2" onClick={() => setPage((p) => p - 1)} disabled={page === 0}>
            Prev
          </button>
          <span className="small">
            Page {page + 1} of {Math.ceil(products.length / pageSize)}
          </span>
          <button className="btn btn-outline-primary btn-sm ms-2" onClick={() => setPage((p) => p + 1)} disabled={end >= products.length}>
            Next
          </button>
        </div>
      </div>
    </div>
  </div>
  )
}

export default App
